jQuery(function($){
    // Tab 切换
    $('.wbt-tab-link').on('click', function(e){
        e.preventDefault();
        var tab = $(this).data('tab');
        $('.wbt-tab-link').removeClass('active');
        $(this).addClass('active');
        $('.wbt-tab-panel').removeClass('active');
        $('#wbt-tab-' + tab).addClass('active');
    });

    // 通用工具表单 AJAX
    $('.wbt-tool-form').on('submit', function(e){
        e.preventDefault();
        var $form = $(this);
        var tool = $form.data('tool');
        var $status = $form.find('.wbt-status');
        $status.removeClass('success error').text('处理中...');

        var data = {
            action: 'wbt_run_tool',
            security: WBT_Ajax.nonce,
            tool: tool
        };

        $form.find('input, select, textarea').each(function(){
            var name = $(this).attr('name');
            if (!name) return;
            data[name] = $(this).val();
        });

        $.post(WBT_Ajax.ajax_url, data, function(resp){
            if (resp && resp.success) {
                $status.addClass('success').text(resp.data && resp.data.message ? resp.data.message : '操作成功');
            } else {
                var msg = resp && resp.data && resp.data.message ? resp.data.message : '操作失败';
                $status.addClass('error').text(msg);
            }
        }).fail(function(){
            $status.addClass('error').text('请求失败，请检查网络或稍后重试');
        });
    });

        // 禁用功能重置（WordPress & WooCommerce）
    $('[data-wbt-reset="wp_features"]').on('click', function(e){
        e.preventDefault();
        var $form = $(this).closest('.wbt-tool-form');
        var $status = $form.find('.wbt-status');
        $status.removeClass('success error').text('重置中...');

        $.post(WBT_Ajax.ajax_url, {
            action: 'wbt_run_tool',
            security: WBT_Ajax.nonce,
            tool: 'toggle_wp_features',
            reset: 1
        }, function(resp){
            if (resp && resp.success) {
                $form.find('input[type="checkbox"]').prop('checked', false);
                $status.addClass('success').text(resp.data && resp.data.message ? resp.data.message : '已恢复默认设置');
            } else {
                var msg = resp && resp.data && resp.data.message ? resp.data.message : '重置失败';
                $status.addClass('error').text(msg);
            }
        }).fail(function(){
            $status.addClass('error').text('请求失败，请检查网络或稍后重试');
        });
    });

    $('[data-wbt-reset="woo_features"]').on('click', function(e){
        e.preventDefault();
        var $form = $(this).closest('.wbt-tool-form');
        var $status = $form.find('.wbt-status');
        $status.removeClass('success error').text('重置中...');

        $.post(WBT_Ajax.ajax_url, {
            action: 'wbt_run_tool',
            security: WBT_Ajax.nonce,
            tool: 'toggle_woo_features',
            reset: 1
        }, function(resp){
            if (resp && resp.success) {
                $form.find('input[type="checkbox"]').prop('checked', false);
                $status.addClass('success').text(resp.data && resp.data.message ? resp.data.message : '已恢复默认设置');
            } else {
                var msg = resp && resp.data && resp.data.message ? resp.data.message : '重置失败';
                $status.addClass('error').text(msg);
            }
        }).fail(function(){
            $status.addClass('error').text('请求失败，请检查网络或稍后重试');
        });
    });

// 远程媒体导入（逐个 AJAX，有进度条）
    $('.wbt-remote-media-form').on('submit', function(e){
        e.preventDefault();
        var $form = $(this);
        var raw = $form.find('textarea[name="urls"]').val() || '';
        var urls = raw.split(/\r?\n/).map(function(u){ return $.trim(u); }).filter(function(u){ return u.length > 0; });

        var $wrap = $form.find('.wbt-progress-wrap');
        var $bar = $wrap.find('.wbt-progress-bar');
        var $status = $wrap.find('.wbt-status');

        if (!urls.length) {
            alert('请先输入至少一个 URL');
            return;
        }

        $wrap.show();
        $bar.css('width', '0%');
        $status.removeClass('success error').text('准备导入，共 ' + urls.length + ' 个');

        var total = urls.length;
        var done = 0;

        function importNext() {
            if (!urls.length) {
                $status.addClass('success').text('全部导入完成，共导入 ' + done + ' 个');
                return;
            }

            var url = urls.shift();
            $status.text('导入中：' + url);

            $.post(WBT_Ajax.ajax_url, {
                action: 'wbt_remote_media_import',
                security: WBT_Ajax.nonce,
                url: url
            }, function(resp){
                done++;
                var percent = Math.round(done / total * 100);
                $bar.css('width', percent + '%');

                if (!resp || !resp.success) {
                    var msg = resp && resp.data && resp.data.message ? resp.data.message : '导入失败';
                    $status.addClass('error').text('第 ' + done + ' 个导入失败：' + msg);
                } else {
                    $status.removeClass('error').text('已导入 ' + done + '/' + total + '，正在继续...');
                }

                importNext();
            }).fail(function(){
                done++;
                var percent = Math.round(done / total * 100);
                $bar.css('width', percent + '%');
                $status.addClass('error').text('第 ' + done + ' 个导入失败（网络错误），继续后续...');
                importNext();
            });
        }

        importNext();
    });
});
