<?php
/**
 * Plugin Name: WP-Tools
 * Description: 全局设置 / Woo / Elementor 批量工具合集（v3）
 * Version: 3.0.0
 * Author: 码力建站
 * Text Domain:https;/www.lihappily.com
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'WBT_Plugin' ) ) :

class WBT_Plugin {

    const OPTION_ELEMENTOR_ORDER = 'wbt_elementor_order_settings';

    private static $instance = null;

    public static function instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'admin_menu', array( $this, 'register_menu' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_assets' ) );
        add_action( 'wp_ajax_wbt_run_tool', array( $this, 'ajax_run_tool' ) );
        add_action( 'wp_ajax_wbt_remote_media_import', array( $this, 'ajax_remote_media_import' ) );

        // Elementor: 跳过结账流程 - 直接生成订单
        add_action( 'elementor_pro/forms/new_record', array( $this, 'handle_elementor_form' ), 10, 2 );

        // Shortcodes + 功能开关
        add_action( 'init', array( $this, 'register_shortcodes' ) );
        add_action( 'init', array( $this, 'apply_disabled_wp_features' ), 1 );
        add_action( 'after_setup_theme', array( $this, 'apply_disabled_wp_features' ), 1 );
        add_action( 'admin_init', array( $this, 'apply_disabled_woo_features' ), 20 );
    }

    public function register_menu() {
        add_menu_page(
            __( 'Woo Bulk Toolkit', 'woo-bulk-toolkit' ),
            __( 'Woo Bulk Toolkit', 'woo-bulk-toolkit' ),
            'manage_options',
            'wbt-toolkit',
            array( $this, 'render_admin_page' ),
            'dashicons-admin-generic',
            56
        );
    }

    public function admin_assets( $hook ) {
        if ( $hook !== 'toplevel_page_wbt-toolkit' ) {
            return;
        }
        wp_enqueue_script(
            'wbt-admin',
            plugin_dir_url( __FILE__ ) . 'assets/admin.js',
            array( 'jquery' ),
            '3.0.0',
            true
        );
        wp_localize_script(
            'wbt-admin',
            'WBT_Ajax',
            array(
                'ajax_url' => admin_url( 'admin-ajax.php' ),
                'nonce'    => wp_create_nonce( 'wbt_nonce' ),
            )
        );
    }

    public function render_admin_page() {
        $elementor_settings    = get_option( self::OPTION_ELEMENTOR_ORDER, array() );
        $wp_disabled_features  = get_option( 'wbt_disabled_features', array() );
        $woo_disabled_features = get_option( 'wbt_disabled_woo_features', array() );
        ?>
        <div class="wrap wbt-wrap">
            <h1>Woo Bulk Toolkit</h1>
            <p>批量操作工具，请谨慎使用红色标记的危险操作。建议先在测试站点使用。</p>

            <style>
                .wbt-wrap {
                    max-width: 1200px;
                    font-size: 16px;
                }
                .wbt-tabs {
                    margin-top: 20px;
                    display: flex;
                    gap: 8px;
                    border-bottom: 1px solid rgba(148, 163, 184, 0.6);
                }
               .wbt-tab-link {
    padding: 20px 28px;
    border-radius: 0px;
    background:none; 
    color: black;
    text-decoration: none;
    font-size: 16px;
    line-height: 1;
    border: 1px solid black;
    margin-bottom: 0;
    white-space: nowrap;
}
.wbt-tab-link.hover {
    background: white; /* 更亮的浅绿色 */
    border-color: black;
    color:black;
    font-weight: 600;
}
.wbt-tab-link.active {
    background: black; /* 更亮的浅绿色 */
    border-color: black;
    font-weight: 600;
    color:white !important;
}
                .wbt-tab-panel {
                    display: none;
                    padding: 20px 18px 22px;
                    border-radius: 0 16px 16px 16px;
                    background: rgba(255, 255, 255, 0.82);
                    margin-top: 0;
                    box-shadow: 0 18px 40px rgba(15, 23, 42, 0.16);
                    border: 1px solid rgba(148, 163, 184, 0.5);
                    backdrop-filter: blur(18px);
                }
                .wbt-tab-panel.active {
                    display: block;
                }
                .wbt-cards {
                    display: grid;
                    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
                    gap: 18px;
                    margin-top: 8px;
                }
                .wbt-card {
                    position: relative;
                    border-radius: 16px;
                    padding: 14px 14px 16px;
                    background: radial-gradient(circle at top left, rgba(255,255,255,0.96), rgba(241,245,249,0.92));
                    border: 1px solid rgba(148, 163, 184, 0.7);
                    display: flex;
                    flex-direction: column;
                    gap: 8px;
                    min-height: 180px;
                    box-shadow: 0 18px 35px rgba(15, 23, 42, 0.12);
                    overflow: hidden;
                }
                .wbt-card-danger {
                    background: radial-gradient(circle at top left, rgba(254,242,242,0.98), rgba(254,226,226,0.95));
                    border-color: rgba(248, 113, 113, 0.9);
                }
                .wbt-card h3 {
                    margin: 0;
                    font-size: 19px;
                    font-weight: 600;
                    display: flex;
                    align-items: center;
                    gap: 8px;
                    color: #0f172a;
                    padding-right: 90px;
                    position: relative;
                    min-height: 24px;
                }
                .wbt-card h3 .title-text {
                    flex: 1 1 auto;
                    min-width: 0;
                    white-space: nowrap;
                    overflow: hidden;
                    text-overflow: ellipsis;
                }
                .wbt-card p {
                    margin: 0;
                    font-size: 14px;
                    color: #4b5563;
                }
                .wbt-badge {
                    display: inline-flex;
                    align-items: center;
                    padding: 3px 9px;
                    border-radius: 999px;
                    font-size: 12px;
                    background: rgba(187, 247, 208, 0.95);
                    color: #047857;
                    white-space: nowrap;
                    position: absolute;
                    right: 0;
                    top: 0;
                }
                .wbt-badge-danger {
                    background: rgba(254, 202, 202, 0.96);
                    color: #b91c1c;
                }
                .wbt-badge-tag {
                    background: rgba(191, 219, 254, 0.96);
                    color: #1d4ed8;
                }
                .wbt-card .dashicons {
                    font-size: 22px;
                    width: 22px;
                    height: 22px;
                }
                .wbt-toolbar {
                    margin-top: 6px;
                    display: flex;
                    gap: 10px;
                    flex-wrap: wrap;
                }
                .wbt-card label {
                    font-size: 14px;
                    color: #111827;
                    display: block;
                    margin-bottom: 4px;
                }
                .wbt-input,
                .wbt-card textarea,
                .wbt-card select {
                    width: 100%;
                    box-sizing: border-box;
                }
                .wbt-card input[type="text"],
                .wbt-card input[type="number"],
                .wbt-card textarea,
                .wbt-card select {
                    margin-top: 3px;
                    padding: 8px 11px;
                    border-radius: 10px;
                    border: 1px solid #cbd5e1;
                    font-size: 14px;
                    background: rgba(255, 255, 255, 0.96);
                    box-shadow: 0 1px 2px rgba(15, 23, 42, 0.04);
                    transition: all .15s ease;
                }
                .wbt-card input[type="text"]:focus,
                .wbt-card input[type="number"]:focus,
                .wbt-card textarea:focus,
                .wbt-card select:focus {
                    border-color: #2563eb;
                    box-shadow: 0 0 0 2px rgba(37, 99, 235, 0.2);
                    outline: none;
                }
                .wbt-card textarea {
                    resize: vertical;
                    min-height: 70px;
                }
                .wbt-flex {
                    display: flex;
                    gap: 10px;
                    flex-wrap: wrap;
                }
                .wbt-input-half {
                    flex: 1 1 48%;
                    min-width: 0;
                }
                .wbt-status {
                    margin-top: 4px;
                    font-size: 13px;
                    min-height: 16px;
                    color: #6b7280;
                    word-break: break-all;
                }
                .wbt-status.success {
                    color: #16a34a;
                }
                .wbt-status.error {
                    color: #b91c1c;
                }
                /* 普通执行按钮 - 绿色 */
.wbt-card .button.button-primary:not(.button-dangerous) {
    background-color: #BDF7D2 !important; /* 浅绿色 */
    border-color: #22c55e !important;
    color: #047857 !important;
}

.wbt-card .button.button-primary:not(.button-dangerous):hover {
    background-color: #16a34a !important; /* 深一点 */
    border-color: #16a34a !important;
     color: white !important
}

                .button-dangerous {
                    background: #ef4444 !important;
                    border-color: #ef4444 !important;
                    color: #ffffff !important;
                }
                .button-dangerous:hover {
                    background: #dc2626 !important;
                    border-color: #dc2626 !important;
                    color: #ffffff !important;
                }
                .wbt-progress-wrap {
                    margin-top: 8px;
                }
                .wbt-progress-bar-bg {
                    width: 100%;
                    height: 8px;
                    background: rgba(226, 232, 240, 0.9);
                    border-radius: 999px;
                    overflow: hidden;
                }
                .wbt-progress-bar {
                    height: 8px;
                    width: 0;
                    background: linear-gradient(90deg, #22c55e, #22d3ee);
                }
            </style>

            <div class="wbt-tabs">
                <a href="#" class="wbt-tab-link active" data-tab="global">
                    全局设置
                </a>
                <a href="#" class="wbt-tab-link" data-tab="woo">
                    Woo
                </a>
                <a href="#" class="wbt-tab-link" data-tab="elementor">
                    Elementor
                </a>
            </div>

            <!-- 全局设置 -->
            <div class="wbt-tab-panel active" id="wbt-tab-global">
                <div class="wbt-cards">
                    <!-- 合并相同分类名 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-editor-table"></span>
                            <span class="title-text">合并相同产品分类名</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>查找名称相同的 <code>product_cat</code> 分类，将产品合并到一个分类，删除多余分类。</p>
                        <form class="wbt-tool-form" data-tool="merge_categories">
                            <label>
                                保留策略：
                                <select name="keep" class="wbt-input">
                                    <option value="first">保留最早创建的分类</option>
                                    <option value="smallest_id">保留 ID 最小的分类</option>
                                </select>
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">开始合并</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 生成菜单 -->
                    <div class="wbt-card">
                        <h3>
                            <span class="dashicons dashicons-menu"></span>
                            <span class="title-text">生成产品菜单（自动创建菜单）</span>
                            <span class="wbt-badge wbt-badge-tag">结构</span>
                        </h3>
                        <p>自动创建一个新菜单，按产品分类生成菜单项，可选择全部层级或按需生成。</p>
                        <form class="wbt-tool-form" data-tool="generate_menus">
                            <label>生成模式
                                <select name="mode" class="wbt-input">
                                    <option value="all_hierarchical">全部产品分类（含父子层级）</option>
                                    <option value="level1">仅一级分类</option>
                                    <option value="level2">二级分类</option>
                                    <option value="siblings">某分类的兄弟分类</option>
                                </select>
                            </label>
                            <label>目标分类 ID（仅二级/兄弟分类模式需要，其他可留空）
                                <input type="number" name="target_cat_id" class="wbt-input" placeholder="例如：12" />
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary" type="submit">生成菜单</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 当前分类统计产品总数（短代码说明 + 当前分类短代码） -->
                    <div class="wbt-card">
                        <h3>
                            <span class="dashicons dashicons-chart-bar"></span>
                            <span class="title-text">当前分类统计产品总数</span>
                            <span class="wbt-badge">短代码</span>
                        </h3>
                        <p>在前端使用短代码输出某个分类及其子分类的产品总数（仅输出数字）：</p>
                        <p style="font-family:monospace;font-size:13px;background:rgba(226,232,240,0.9);border-radius:8px;padding:6px 8px;">
                            [wbt_cat_count id="123"]<br/>
                            [wbt_cat_count slug="clothes"]<br/><br/>
                            <!-- 当前产品分类页面自动识别当前分类： --><br/>
                            [wbt_current_cat_count]
                        </p>
                        <p style="font-size:13px;color:#6b7280;">备注：<code>wbt_current_cat_count</code> 仅在产品分类页面使用，自动识别当前分类并输出总数。</p>
                        <div class="wbt-status">无需在后台操作，直接在页面/分类描述等位置使用短代码即可。</div>
                    </div>

                    <!-- Elementor 表单直接生成订单 设置 -->
                    <div class="wbt-card">
                        <h3>
                            <span class="dashicons dashicons-forms"></span>
                            <span class="title-text">Elementor 表单直接生成订单</span>
                            <span class="wbt-badge wbt-badge-tag">设置</span>
                        </h3>
                        <p>配置一个 Elementor 表单名称，提交后自动创建一个订单（不添加产品，仅记录客户信息和状态）。</p>
                        <form class="wbt-tool-form" data-tool="elementor_order_settings">
                            <div class="wbt-flex">
                                <div class="wbt-input-half">
                                    <label>表单名称（Form Name）
                                        <input type="text" name="form_name" class="wbt-input" placeholder="与 Elementor 表单名称一致" value="<?php echo isset( $elementor_settings['form_name'] ) ? esc_attr( $elementor_settings['form_name'] ) : ''; ?>" />
                                    </label>
                                </div>
                                <div class="wbt-input-half">
                                    <label>订单状态
                                        <select name="order_status" class="wbt-input">
                                            <?php
                                            $current_status = isset( $elementor_settings['order_status'] ) ? $elementor_settings['order_status'] : 'processing';
                                            $statuses = array(
                                                'processing' => 'processing',
                                                'completed'  => 'completed',
                                                'on-hold'    => 'on-hold',
                                            );
                                            foreach ( $statuses as $key => $label ) {
                                                printf(
                                                    '<option value="%1$s"%2$s>%3$s</option>',
                                                    esc_attr( $key ),
                                                    selected( $current_status, $key, false ),
                                                    esc_html( $label )
                                                );
                                            }
                                            ?>
                                        </select>
                                    </label>
                                </div>
                            </div>
                            <div class="wbt-flex">
                                <div class="wbt-input-half">
                                    <label>姓名字段 key
                                        <input type="text" name="name_field" class="wbt-input" placeholder="如：name" value="<?php echo isset( $elementor_settings['name_field'] ) ? esc_attr( $elementor_settings['name_field'] ) : ''; ?>" />
                                    </label>
                                </div>
                                <div class="wbt-input-half">
                                    <label>邮箱字段 key
                                        <input type="text" name="email_field" class="wbt-input" placeholder="如：email" value="<?php echo isset( $elementor_settings['email_field'] ) ? esc_attr( $elementor_settings['email_field'] ) : ''; ?>" />
                                    </label>
                                </div>
                            </div>
                            <div class="wbt-toolbar">
                                <button class="button button-primary" type="submit">保存设置</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 远程媒体导入 -->
                    <div class="wbt-card">
                        <h3>
                            <span class="dashicons dashicons-upload"></span>
                            <span class="title-text">远程媒体导入</span>
                            <span class="wbt-badge wbt-badge-tag">AJAX</span>
                        </h3>
                        <p>逐个通过 AJAX 导入远程图片地址，有进度条，完成后直接在卡片内提示，不刷新、不弹窗。</p>
                        <form class="wbt-remote-media-form">
                            <label>图片 URL（每行一个）
                                <textarea name="urls" rows="4" class="wbt-input" placeholder="https://example.com/a.jpg&#10;https://example.com/b.png"></textarea>
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary" type="submit">开始导入</button>
                            </div>
                            <div class="wbt-progress-wrap" style="display:none;">
                                <div class="wbt-progress-bar-bg">
                                    <div class="wbt-progress-bar"></div>
                                </div>
                                <div class="wbt-status"></div>
                            </div>
                        </form>
                    </div>

                    <!-- 批量创建页面 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-media-document"></span>
                            <span class="title-text">批量创建页面</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>根据每行一个标题批量创建页面，可选择父级与状态。</p>
                        <form class="wbt-tool-form" data-tool="bulk_create_pages">
                            <label>页面标题列表（每行一个）
                                <textarea name="titles" rows="4" class="wbt-input" placeholder="关于我们&#10;联系我们&#10;售后服务"></textarea>
                            </label>
                            <div class="wbt-flex">
                                <div class="wbt-input-half">
                                    <label>父级页面 ID（可选）
                                        <input type="number" name="parent_id" class="wbt-input" />
                                    </label>
                                </div>
                                <div class="wbt-input-half">
                                    <label>状态
                                        <select name="status" class="wbt-input">
                                            <option value="publish">发布</option>
                                            <option value="draft">草稿</option>
                                        </select>
                                    </label>
                                </div>
                            </div>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">创建页面</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>
                    <!-- 禁用 WordPress 无用功能 -->
<div class="wbt-card">
    <h3>
        <span class="dashicons dashicons-shield-alt"></span>
        <span class="title-text">禁用无用的 WordPress 功能</span>
        <span class="wbt-badge wbt-badge-tag">优化</span>
    </h3>

    <p>以下功能可自由启用/禁用（保存后立即生效）。</p>

    <form class="wbt-tool-form" data-tool="toggle_wp_features">
        <label><input type="checkbox" name="disable_comments" <?php if ( ! empty( $wp_disabled_features['disable_comments'] ) ) echo 'checked="checked"'; ?>> 禁用评论</label><br>
        <label><input type="checkbox" name="disable_xmlrpc" <?php if ( ! empty( $wp_disabled_features['disable_xmlrpc'] ) ) echo 'checked="checked"'; ?>> 禁用 XML-RPC</label><br>
        <label><input type="checkbox" name="disable_feed" <?php if ( ! empty( $wp_disabled_features['disable_feed'] ) ) echo 'checked="checked"'; ?>> 禁用 RSS Feed</label><br>
        <label><input type="checkbox" name="disable_emoji" <?php if ( ! empty( $wp_disabled_features['disable_emoji'] ) ) echo 'checked="checked"'; ?>> 禁用 Emoji</label><br>
        <label><input type="checkbox" name="disable_embeds" <?php if ( ! empty( $wp_disabled_features['disable_embeds'] ) ) echo 'checked="checked"'; ?>> 禁用 Embeds</label><br>
        <label><input type="checkbox" name="disable_rest_api" <?php if ( ! empty( $wp_disabled_features['disable_rest_api'] ) ) echo 'checked="checked"'; ?>> 禁用 REST API（未登录用户）</label><br>
        <label><input type="checkbox" name="disable_admin_bar" <?php if ( ! empty( $wp_disabled_features['disable_admin_bar'] ) ) echo 'checked="checked"'; ?>> 隐藏前端管理员工具栏</label><br>
        <label><input type="checkbox" name="disable_auto_update" <?php if ( ! empty( $wp_disabled_features['disable_auto_update'] ) ) echo 'checked="checked"'; ?>> 禁用自动更新</label><br>
        <label><input type="checkbox" name="disable_wp_cron" <?php if ( ! empty( $wp_disabled_features['disable_wp_cron'] ) ) echo 'checked="checked"'; ?>> 禁用 WP Cron</label><br>
        <label><input type="checkbox" name="disable_sitemap" <?php if ( ! empty( $wp_disabled_features['disable_sitemap'] ) ) echo 'checked="checked"'; ?>> 禁用 WP 自动站点地图</label><br>
        <label><input type="checkbox" name="disable_oembed_discovery" <?php if ( ! empty( $wp_disabled_features['disable_oembed_discovery'] ) ) echo 'checked="checked"'; ?>> 禁用 oEmbed</label><br>
        <label><input type="checkbox" name="disable_shortlink" <?php if ( ! empty( $wp_disabled_features['disable_shortlink'] ) ) echo 'checked="checked"'; ?>> 禁用短链接 Shortlink</label><br>
        <label><input type="checkbox" name="disable_generator_meta" <?php if ( ! empty( $wp_disabled_features['disable_generator_meta'] ) ) echo 'checked="checked"'; ?>> 禁用 meta generator 标签</label><br>

        <div class="wbt-toolbar">
            <button class="button button-primary" type="submit">保存设置</button>
            <button class="button" type="button" data-wbt-reset="wp_features">恢复默认</button>
        </div>
        <div class="wbt-status"></div>
    </form>
</div>

                </div>
            </div>

            <!-- Woo -->
            <div class="wbt-tab-panel" id="wbt-tab-woo">
                <div class="wbt-cards">
                    <!-- 统一生成唯一 SKU -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-tag"></span>
                            <span class="title-text">统一生成唯一 SKU</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>为所有没有 SKU 的产品及变体生成唯一 SKU，可选前缀。</p>
                        <form class="wbt-tool-form" data-tool="generate_sku">
                            <label>SKU 前缀（可选）
                                <input type="text" name="prefix" class="wbt-input" placeholder="例如：SKU-" />
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">生成 SKU</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 统一产品价格 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-tickets-alt"></span>
                            <span class="title-text">统一产品价格</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>将所有产品（含变体）的常规价格设置为同一个值。</p>
                        <form class="wbt-tool-form" data-tool="set_all_prices">
                            <label>新价格
                                <input type="number" step="0.01" name="price" class="wbt-input" placeholder="例如：99.00" />
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">设置价格</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 统一产品库存 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-archive"></span>
                            <span class="title-text">统一产品库存</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>将所有产品及变体库存设置为同一个数量，并启用库存管理。</p>
                        <form class="wbt-tool-form" data-tool="set_all_stock">
                            <label>库存数量
                                <input type="number" name="stock" class="wbt-input" placeholder="例如：100" />
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">设置库存</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 产品可购/不可购买 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-cart"></span>
                            <span class="title-text">统一产品可购或不可购买</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>将所有产品库存状态统一为可购买或不可购买（instock / outofstock）。</p>
                        <form class="wbt-tool-form" data-tool="set_purchasable">
                            <label>可购状态
                                <select name="mode" class="wbt-input">
                                    <option value="instock">可购买（instock）</option>
                                    <option value="outofstock">不可购买（outofstock）</option>
                                </select>
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">统一设置</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 所有产品变为可变产品 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-randomize"></span>
                            <span class="title-text">所有产品变为可变产品</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>将所有 simple 类型产品转为 variable 类型（不会自动创建变体）。</p>
                        <form class="wbt-tool-form" data-tool="convert_variable">
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">转换产品类型</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 添加所有已有属性到全部产品 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-list-view"></span>
                            <span class="title-text">添加所有已有属性到全部产品</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>为所有产品添加当前站点已有的全局属性（不自动分配具体属性值）。</p>
                        <form class="wbt-tool-form" data-tool="add_all_attributes">
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">添加属性</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 为产品生成所有已有属性的变体 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-networking"></span>
                            <span class="title-text">为产品生成所有已有属性的变体</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>对已有属性与属性值的可变产品，调用 WooCommerce 内置逻辑生成所有组合的变体。</p>
                        <form class="wbt-tool-form" data-tool="generate_all_variations">
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">生成所有变体</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 所有产品可以折扣 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-money"></span>
                            <span class="title-text">所有产品可以折扣</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>按百分比为所有产品设置折扣价（sale price），基于当前常规价计算。</p>
                        <form class="wbt-tool-form" data-tool="global_discount">
                            <label>折扣百分比（例如 10 表示 10% 折扣）
                                <input type="number" step="0.01" name="percent" class="wbt-input" placeholder="例如：10" />
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">应用折扣</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 所有变体产品价格 -->
                    <div class="wbt-card wbt-card-danger">
                        <h3>
                            <span class="dashicons dashicons-editor-italic"></span>
                            <span class="title-text">统一设置所有变体价格</span>
                            <span class="wbt-badge wbt-badge-danger">危险</span>
                        </h3>
                        <p>统一设置所有变体的价格为指定数值（仅影响变体，不影响主产品）。</p>
                        <form class="wbt-tool-form" data-tool="set_variation_prices">
                            <label>变体价格
                                <input type="number" step="0.01" name="price" class="wbt-input" placeholder="例如：79.00" />
                            </label>
                            <div class="wbt-toolbar">
                                <button class="button button-primary button-dangerous" type="submit">设置变体价格</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>

                    <!-- 禁用 WooCommerce 冗余功能 -->
                    <div class="wbt-card">
                        <h3>
                            <span class="dashicons dashicons-shield"></span>
                            <span class="title-text">禁用 WooCommerce 冗余功能</span>
                            <span class="wbt-badge wbt-badge-tag">优化</span>
                        </h3>
                        <p>勾选要禁用的 Woo 功能模块，保存后可随时再启用。</p>
                        <form class="wbt-tool-form" data-tool="toggle_woo_features">
                            <label><input type="checkbox" name="disable_woo_admin" <?php if ( ! empty( $woo_disabled_features['disable_woo_admin'] ) ) echo 'checked="checked"'; ?>> 禁用 Woo Admin（新后台主页）</label><br>
                            <label><input type="checkbox" name="disable_woo_analytics" <?php if ( ! empty( $woo_disabled_features['disable_woo_analytics'] ) ) echo 'checked="checked"'; ?>> 禁用 Analytics（分析）</label><br>
                            <label><input type="checkbox" name="disable_woo_marketing" <?php if ( ! empty( $woo_disabled_features['disable_woo_marketing'] ) ) echo 'checked="checked"'; ?>> 禁用 Marketing（营销）</label><br>
                            <label><input type="checkbox" name="disable_woo_remote_inbox" <?php if ( ! empty( $woo_disabled_features['disable_woo_remote_inbox'] ) ) echo 'checked="checked"'; ?>> 禁用远程消息 / 提示（Inbox 通知）</label><br>
                            <label><input type="checkbox" name="disable_woo_marketplace" <?php if ( ! empty( $woo_disabled_features['disable_woo_marketplace'] ) ) echo 'checked="checked"'; ?>> 禁用推荐扩展 / 市场推广</label><br>
                            <label><input type="checkbox" name="disable_woo_marketing_tracks" <?php if ( ! empty( $woo_disabled_features['disable_woo_marketing_tracks'] ) ) echo 'checked="checked"'; ?>> 禁用营销跟踪 / 统计上报</label><br>

                            <div class="wbt-toolbar">
                                <button class="button button-primary" type="submit">保存设置</button>
                                <button class="button" type="button" data-wbt-reset="woo_features">恢复默认</button>
                            </div>
                            <div class="wbt-status"></div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Elementor -->
            <div class="wbt-tab-panel" id="wbt-tab-elementor">
                <div class="wbt-cards">
                    <div class="wbt-card">
                        <h3>
                            <span class="dashicons dashicons-layout"></span>
                            <span class="title-text">Elementor 专用工具（预留）</span>
                            <span class="wbt-badge wbt-badge-tag">扩展位</span>
                        </h3>
                        <p>当前 Elementor Tab 仅配合“表单直接生成订单”的全局设置使用，后续可扩展更多可视化工具。</p>
                        <div class="wbt-status">暂无额外操作。</div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    public function ajax_run_tool() {
        check_ajax_referer( 'wbt_nonce', 'security' );

        if ( ! current_user_can( 'manage_woocommerce' ) && ! current_user_can( 'manage_options' ) ) {
            wp_send_json_error( array( 'message' => '权限不足' ) );
        }

        $tool = isset( $_POST['tool'] ) ? sanitize_text_field( wp_unslash( $_POST['tool'] ) ) : '';

        if ( empty( $tool ) ) {
            wp_send_json_error( array( 'message' => '缺少工具标识' ) );
        }

        switch ( $tool ) {
            case 'merge_categories':
                $keep = isset( $_POST['keep'] ) ? sanitize_text_field( wp_unslash( $_POST['keep'] ) ) : 'first';
                $result = $this->tool_merge_categories( $keep );
                break;

            case 'generate_menus':
                $mode          = isset( $_POST['mode'] ) ? sanitize_text_field( wp_unslash( $_POST['mode'] ) ) : 'all_hierarchical';
                $target_cat_id = isset( $_POST['target_cat_id'] ) ? intval( $_POST['target_cat_id'] ) : 0;
                $result        = $this->tool_generate_menus( $mode, $target_cat_id );
                break;

            case 'elementor_order_settings':
                $data = array(
                    'form_name'   => isset( $_POST['form_name'] ) ? sanitize_text_field( wp_unslash( $_POST['form_name'] ) ) : '',
                    'order_status'=> isset( $_POST['order_status'] ) ? sanitize_text_field( wp_unslash( $_POST['order_status'] ) ) : 'processing',
                    'name_field'  => isset( $_POST['name_field'] ) ? sanitize_text_field( wp_unslash( $_POST['name_field'] ) ) : '',
                    'email_field' => isset( $_POST['email_field'] ) ? sanitize_text_field( wp_unslash( $_POST['email_field'] ) ) : '',
                );
                update_option( self::OPTION_ELEMENTOR_ORDER, $data );
                $result = array( 'message' => '设置已保存' );
                break;

            case 'bulk_create_pages':
                $titles_raw = isset( $_POST['titles'] ) ? wp_unslash( $_POST['titles'] ) : '';
                $parent_id  = isset( $_POST['parent_id'] ) ? intval( $_POST['parent_id'] ) : 0;
                $status     = isset( $_POST['status'] ) ? sanitize_text_field( wp_unslash( $_POST['status'] ) ) : 'publish';
                $result     = $this->tool_bulk_create_pages( $titles_raw, $parent_id, $status );
                break;

            case 'generate_sku':
                $prefix = isset( $_POST['prefix'] ) ? sanitize_text_field( wp_unslash( $_POST['prefix'] ) ) : '';
                $result = $this->tool_generate_sku( $prefix );
                break;

            case 'set_all_prices':
                $price  = isset( $_POST['price'] ) ? floatval( $_POST['price'] ) : 0;
                $result = $this->tool_set_all_prices( $price );
                break;

            case 'set_all_stock':
                $stock  = isset( $_POST['stock'] ) ? intval( $_POST['stock'] ) : 0;
                $result = $this->tool_set_all_stock( $stock );
                break;

            case 'set_purchasable':
                $mode   = isset( $_POST['mode'] ) ? sanitize_text_field( wp_unslash( $_POST['mode'] ) ) : 'instock';
                $result = $this->tool_set_purchasable( $mode );
                break;

            case 'convert_variable':
                $result = $this->tool_convert_variable();
                break;

            case 'add_all_attributes':
                $result = $this->tool_add_all_attributes();
                break;

            case 'generate_all_variations':
                $result = $this->tool_generate_all_variations();
                break;

            case 'global_discount':
                $percent = isset( $_POST['percent'] ) ? floatval( $_POST['percent'] ) : 0;
                $result  = $this->tool_global_discount( $percent );
                break;

            case 'set_variation_prices':
                $price  = isset( $_POST['price'] ) ? floatval( $_POST['price'] ) : 0;
                $result = $this->tool_set_variation_prices( $price );
                break;

            case 'toggle_wp_features':
                $result = $this->save_wp_feature_settings( $_POST );
                break;

            case 'toggle_woo_features':
                $result = $this->save_woo_feature_settings( $_POST );
                break;

            default:
                wp_send_json_error( array( 'message' => '未知工具：' . esc_html( $tool ) ) );
        }

        if ( isset( $result['error'] ) ) {
            wp_send_json_error( array( 'message' => $result['error'] ) );
        } else {
            wp_send_json_success( $result );
        }
    }

    public function ajax_remote_media_import() {
        check_ajax_referer( 'wbt_nonce', 'security' );

        if ( ! current_user_can( 'upload_files' ) ) {
            wp_send_json_error( array( 'message' => '权限不足' ) );
        }

        $url = isset( $_POST['url'] ) ? esc_url_raw( wp_unslash( $_POST['url'] ) ) : '';

        if ( empty( $url ) ) {
            wp_send_json_error( array( 'message' => 'URL 为空' ) );
        }

        if ( ! function_exists( 'media_sideload_image' ) ) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            require_once ABSPATH . 'wp-admin/includes/media.php';
            require_once ABSPATH . 'wp-admin/includes/image.php';
        }

        $attach_id = 0;
        try {
            $tmp = download_url( $url );
            if ( is_wp_error( $tmp ) ) {
                wp_send_json_error( array( 'message' => $tmp->get_error_message() ) );
            }

            $file_array = array(
                'name'     => basename( parse_url( $url, PHP_URL_PATH ) ),
                'tmp_name' => $tmp,
            );

            $attach_id = media_handle_sideload( $file_array, 0 );
            if ( is_wp_error( $attach_id ) ) {
                @unlink( $tmp );
                wp_send_json_error( array( 'message' => $attach_id->get_error_message() ) );
            }
        } catch ( Exception $e ) {
            wp_send_json_error( array( 'message' => $e->getMessage() ) );
        }

        wp_send_json_success( array( 'message' => '导入成功', 'attachment_id' => $attach_id ) );
    }

    /* ========== 短代码 ========== */

    public function register_shortcodes() {
        add_shortcode( 'wbt_cat_count', array( $this, 'shortcode_cat_count' ) );
        add_shortcode( 'wbt_current_cat_count', array( $this, 'shortcode_current_cat_count' ) );
    }

    public function shortcode_cat_count( $atts ) {
        $atts = shortcode_atts(
            array(
                'id'   => '',
                'slug' => '',
            ),
            $atts,
            'wbt_cat_count'
        );

        $cat_id   = intval( $atts['id'] );
        $cat_slug = sanitize_title( $atts['slug'] );

        $result = $this->tool_count_category_products( $cat_id, $cat_slug );

        if ( isset( $result['error'] ) ) {
            return esc_html( $result['error'] );
        }

        return isset( $result['count'] ) ? intval( $result['count'] ) : '';
    }

    public function shortcode_current_cat_count( $atts ) {
        if ( ! is_tax( 'product_cat' ) ) {
            return esc_html__( '仅在产品分类页面可用', 'woo-bulk-toolkit' );
        }

        $obj = get_queried_object();
        if ( ! $obj || ! isset( $obj->term_id ) ) {
            return esc_html__( '无法获取当前分类', 'woo-bulk-toolkit' );
        }

        $result = $this->tool_count_category_products( intval( $obj->term_id ), '' );
        if ( isset( $result['error'] ) ) {
            return esc_html( $result['error'] );
        }

        return isset( $result['count'] ) ? intval( $result['count'] ) : '';
    }

    /* ========== 工具实现 ========== */

    private function tool_merge_categories( $keep_strategy = 'first' ) {
        $terms = get_terms( array(
            'taxonomy'   => 'product_cat',
            'hide_empty' => false,
        ) );

        if ( is_wp_error( $terms ) ) {
            return array( 'error' => $terms->get_error_message() );
        }

        $grouped = array();
        foreach ( $terms as $term ) {
            $grouped[ $term->name ][] = $term;
        }

        $merged_count = 0;
        foreach ( $grouped as $name => $list ) {
            if ( count( $list ) <= 1 ) {
                continue;
            }

            $keep_term = $list[0];
            if ( 'smallest_id' === $keep_strategy ) {
                foreach ( $list as $t ) {
                    if ( $t->term_id < $keep_term->term_id ) {
                        $keep_term = $t;
                    }
                }
            }

            foreach ( $list as $t ) {
                if ( $t->term_id === $keep_term->term_id ) {
                    continue;
                }

                $posts = get_posts( array(
                    'post_type'      => 'product',
                    'posts_per_page' => -1,
                    'tax_query'      => array(
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'term_id',
                            'terms'    => $t->term_id,
                        ),
                    ),
                    'fields' => 'ids',
                ) );

                foreach ( $posts as $pid ) {
                    wp_set_object_terms( $pid, (int) $keep_term->term_id, 'product_cat', true );
                }

                wp_delete_term( $t->term_id, 'product_cat' );
                $merged_count++;
            }
        }

        return array(
            'message' => '合并完成，处理重复名称分组数量：' . $merged_count,
        );
    }

    private function tool_generate_menus( $mode, $target_cat_id ) {
        // 自动创建一个新菜单
        $menu_name = 'WBT Menu ' . wp_rand( 1000, 9999 );
        $menu_id   = wp_create_nav_menu( $menu_name );

        if ( is_wp_error( $menu_id ) || ! $menu_id ) {
            return array( 'error' => '创建菜单失败' );
        }

        $created = 0;

        if ( 'all_hierarchical' === $mode ) {
            $top_terms = get_terms( array(
                'taxonomy'   => 'product_cat',
                'hide_empty' => false,
                'parent'     => 0,
            ) );

            if ( empty( $top_terms ) || is_wp_error( $top_terms ) ) {
                return array( 'error' => '未找到产品分类' );
            }

            foreach ( $top_terms as $term ) {
                $this->add_term_to_menu_recursive( $term, $menu_id, 0, $created );
            }
        } elseif ( 'level1' === $mode ) {
            $terms = get_terms( array(
                'taxonomy'   => 'product_cat',
                'hide_empty' => false,
                'parent'     => 0,
            ) );
            if ( empty( $terms ) || is_wp_error( $terms ) ) {
                return array( 'error' => '未找到一级产品分类' );
            }
            foreach ( $terms as $term ) {
                $this->add_term_to_menu_recursive( $term, $menu_id, 0, $created, false );
            }
        } elseif ( 'level2' === $mode ) {
            if ( $target_cat_id ) {
                $terms = get_terms( array(
                    'taxonomy'   => 'product_cat',
                    'hide_empty' => false,
                    'parent'     => $target_cat_id,
                ) );
            } else {
                $terms = get_terms( array(
                    'taxonomy'   => 'product_cat',
                    'hide_empty' => false,
                ) );
                if ( ! is_wp_error( $terms ) ) {
                    $terms = array_filter( $terms, function( $t ) {
                        $parent = get_term( $t->parent, 'product_cat' );
                        return $t->parent > 0 && $parent && ! is_wp_error( $parent ) && $parent->parent == 0;
                    } );
                }
            }

            if ( empty( $terms ) || is_wp_error( $terms ) ) {
                return array( 'error' => '未找到二级产品分类' );
            }

            foreach ( $terms as $term ) {
                $this->add_term_to_menu_recursive( $term, $menu_id, 0, $created, false );
            }
        } else { // siblings
            if ( ! $target_cat_id ) {
                return array( 'error' => '兄弟分类模式需要提供目标分类 ID' );
            }
            $current = get_term( $target_cat_id, 'product_cat' );
            if ( ! $current || is_wp_error( $current ) ) {
                return array( 'error' => '目标分类不存在' );
            }
            $terms = get_terms( array(
                'taxonomy'   => 'product_cat',
                'hide_empty' => false,
                'parent'     => $current->parent,
            ) );
            if ( empty( $terms ) || is_wp_error( $terms ) ) {
                return array( 'error' => '未找到兄弟分类' );
            }
            foreach ( $terms as $term ) {
                $this->add_term_to_menu_recursive( $term, $menu_id, 0, $created, false );
            }
        }

        return array(
            'message' => sprintf(
                '菜单 “%s” 已创建并生成 %d 个菜单项，请在外观 → 菜单中分配到菜单位置。',
                $menu_name,
                $created
            ),
        );
    }

    private function add_term_to_menu_recursive( $term, $menu_id, $parent_item_id, &$created, $with_children = true ) {
        $link = get_term_link( $term );
        if ( is_wp_error( $link ) ) {
            return;
        }

        $item_id = wp_update_nav_menu_item(
            $menu_id,
            0,
            array(
                'menu-item-title'     => $term->name,
                'menu-item-url'       => $link,
                'menu-item-status'    => 'publish',
                'menu-item-parent-id' => $parent_item_id,
            )
        );

        if ( is_wp_error( $item_id ) ) {
            return;
        }

        $created++;

        if ( ! $with_children ) {
            return;
        }

        $children = get_terms( array(
            'taxonomy'   => 'product_cat',
            'hide_empty' => false,
            'parent'     => $term->term_id,
        ) );

        if ( empty( $children ) || is_wp_error( $children ) ) {
            return;
        }

        foreach ( $children as $child ) {
            $this->add_term_to_menu_recursive( $child, $menu_id, $item_id, $created, true );
        }
    }

    private function tool_count_category_products( $cat_id, $cat_slug ) {
        if ( ! $cat_id && $cat_slug ) {
            $term = get_term_by( 'slug', $cat_slug, 'product_cat' );
            if ( $term ) {
                $cat_id = $term->term_id;
            }
        }

        if ( ! $cat_id ) {
            return array( 'error' => '请提供有效的分类 ID 或别名（slug）' );
        }

        $term = get_term( $cat_id, 'product_cat' );
        if ( ! $term || is_wp_error( $term ) ) {
            return array( 'error' => '分类不存在' );
        }

        $term_ids = array( $term->term_id );
        $children = get_term_children( $term->term_id, 'product_cat' );
        if ( ! is_wp_error( $children ) && ! empty( $children ) ) {
            $term_ids = array_merge( $term_ids, array_map( 'intval', $children ) );
        }

        $query = new WP_Query( array(
            'post_type'      => 'product',
            'posts_per_page' => -1,
            'fields'         => 'ids',
            'tax_query'      => array(
                array(
                    'taxonomy' => 'product_cat',
                    'field'    => 'term_id',
                    'terms'    => $term_ids,
                ),
            ),
        ) );

        return array(
            'message' => sprintf(
                '该分类（%s，ID: %d）及其所有子分类下共有产品：%d 个',
                $term->name,
                $term->term_id,
                $query->post_count
            ),
            'count'   => intval( $query->post_count ),
        );
    }

    private function tool_bulk_create_pages( $titles_raw, $parent_id, $status ) {
        $titles = preg_split( '/\r\n|\r|\n/', $titles_raw );
        $titles = array_filter( array_map( 'trim', (array) $titles ) );

        if ( empty( $titles ) ) {
            return array( 'error' => '请输入至少一个页面标题' );
        }

        $created = 0;
        foreach ( $titles as $title ) {
            $postarr = array(
                'post_title'  => $title,
                'post_status' => $status,
                'post_type'   => 'page',
                'post_parent' => $parent_id,
            );
            $pid = wp_insert_post( $postarr );
            if ( $pid && ! is_wp_error( $pid ) ) {
                $created++;
            }
        }

        return array(
            'message' => '批量创建页面完成，共创建：' . $created,
        );
    }

    private function tool_generate_sku( $prefix ) {
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $args = array(
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        );
        $product_ids = wc_get_products( $args );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }

            if ( ! $product->get_sku() ) {
                $product->set_sku( $this->generate_unique_sku( $prefix, $pid ) );
                $product->save();
                $count++;
            }

            if ( $product->is_type( 'variable' ) ) {
                foreach ( $product->get_children() as $vid ) {
                    $variation = wc_get_product( $vid );
                    if ( $variation && ! $variation->get_sku() ) {
                        $variation->set_sku( $this->generate_unique_sku( $prefix, $vid ) );
                        $variation->save();
                        $count++;
                    }
                }
            }
        }

        return array(
            'message' => 'SKU 生成完成，修改数量：' . $count,
        );
    }

    private function generate_unique_sku( $prefix, $id ) {
        $base = $prefix . $id;
        $sku  = $base;
        $i    = 1;
        while ( wc_get_product_id_by_sku( $sku ) ) {
            $sku = $base . '-' . $i;
            $i++;
        }
        return $sku;
    }

    private function tool_set_all_prices( $price ) {
        if ( $price <= 0 ) {
            return array( 'error' => '价格必须大于 0' );
        }
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $product_ids = wc_get_products( array(
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }
            $product->set_regular_price( $price );
            $product->set_price( $price );
            $product->save();
            $count++;

            if ( $product->is_type( 'variable' ) ) {
                foreach ( $product->get_children() as $vid ) {
                    $variation = wc_get_product( $vid );
                    if ( ! $variation ) {
                        continue;
                    }
                    $variation->set_regular_price( $price );
                    $variation->set_price( $price );
                    $variation->save();
                    $count++;
                }
            }
        }

        return array(
            'message' => '价格已统一设置，共处理产品/变体：' . $count,
        );
    }

    private function tool_set_all_stock( $stock ) {
        if ( $stock < 0 ) {
            return array( 'error' => '库存不能为负数' );
        }
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $product_ids = wc_get_products( array(
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }
            $product->set_manage_stock( true );
            $product->set_stock_quantity( $stock );
            $product->set_stock_status( $stock > 0 ? 'instock' : 'outofstock' );
            $product->save();
            $count++;

            if ( $product->is_type( 'variable' ) ) {
                foreach ( $product->get_children() as $vid ) {
                    $variation = wc_get_product( $vid );
                    if ( ! $variation ) {
                        continue;
                    }
                    $variation->set_manage_stock( true );
                    $variation->set_stock_quantity( $stock );
                    $variation->set_stock_status( $stock > 0 ? 'instock' : 'outofstock' );
                    $variation->save();
                    $count++;
                }
            }
        }

        return array(
            'message' => '库存已统一设置，共处理产品/变体：' . $count,
        );
    }

    private function tool_set_purchasable( $mode ) {
        if ( ! in_array( $mode, array( 'instock', 'outofstock' ), true ) ) {
            return array( 'error' => '模式必须为 instock 或 outofstock' );
        }
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $product_ids = wc_get_products( array(
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }
            $product->set_stock_status( $mode );
            $product->save();
            $count++;

            if ( $product->is_type( 'variable' ) ) {
                foreach ( $product->get_children() as $vid ) {
                    $variation = wc_get_product( $vid );
                    if ( ! $variation ) {
                        continue;
                    }
                    $variation->set_stock_status( $mode );
                    $variation->save();
                    $count++;
                }
            }
        }

        return array(
            'message' => '可购状态已统一设置为 ' . $mode . '，共处理：' . $count,
        );
    }

    private function tool_convert_variable() {
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $product_ids = wc_get_products( array(
            'type'   => array( 'simple' ),
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }
            $product->set_type( 'variable' );
            $product->save();
            $count++;
        }

        return array(
            'message' => '已将 simple 产品转换为 variable，数量：' . $count,
        );
    }

    private function tool_add_all_attributes() {
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $attribute_taxonomies = wc_get_attribute_taxonomies();
        if ( empty( $attribute_taxonomies ) ) {
            return array( 'error' => '当前没有全局属性' );
        }

        $attr_names = array();
        foreach ( $attribute_taxonomies as $tax ) {
            $attr_names[] = wc_attribute_taxonomy_name( $tax->attribute_name );
        }

        $product_ids = wc_get_products( array(
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }

            $attributes = $product->get_attributes();
            foreach ( $attr_names as $tax_name ) {
                if ( isset( $attributes[ $tax_name ] ) ) {
                    continue;
                }
                $attr = new WC_Product_Attribute();
                $attr->set_id( 0 );
                $attr->set_name( $tax_name );
                $attr->set_options( array() );
                $attr->set_position( count( $attributes ) );
                $attr->set_visible( true );
                $attr->set_variation( true );
                $attributes[ $tax_name ] = $attr;
            }

            $product->set_attributes( $attributes );
            $product->save();
            $count++;
        }

        return array(
            'message' => '已为产品添加全局属性定义，处理数量：' . $count,
        );
    }

    private function tool_generate_all_variations() {
        if ( ! class_exists( 'WC_Product_Variable' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        if ( ! function_exists( 'wc_create_all_variations' ) ) {
            require_once WC_ABSPATH . 'includes/admin/wc-admin-functions.php';
        }

        $product_ids = wc_get_products( array(
            'type'   => array( 'variable' ),
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product || ! $product->is_type( 'variable' ) ) {
                continue;
            }
            try {
                wc_create_all_variations( $pid );
                $count++;
            } catch ( Exception $e ) {
                // 忽略单个产品错误
            }
        }

        return array(
            'message' => '已调用 WooCommerce 生成所有变体逻辑，处理 variable 产品数量：' . $count,
        );
    }

    private function tool_global_discount( $percent ) {
        if ( $percent <= 0 ) {
            return array( 'error' => '折扣百分比必须大于 0' );
        }
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $product_ids = wc_get_products( array(
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        $ratio = ( 100 - $percent ) / 100;

        foreach ( $product_ids as $pid ) {
            $product = wc_get_product( $pid );
            if ( ! $product ) {
                continue;
            }

            $price = floatval( $product->get_regular_price() );
            if ( $price <= 0 ) {
                continue;
            }
            $sale = round( $price * $ratio, wc_get_price_decimals() );
            $product->set_sale_price( $sale );
            $product->set_price( $sale );
            $product->save();
            $count++;

            if ( $product->is_type( 'variable' ) ) {
                foreach ( $product->get_children() as $vid ) {
                    $variation = wc_get_product( $vid );
                    if ( ! $variation ) {
                        continue;
                    }
                    $vp = floatval( $variation->get_regular_price() );
                    if ( $vp <= 0 ) {
                        continue;
                    }
                    $vsale = round( $vp * $ratio, wc_get_price_decimals() );
                    $variation->set_sale_price( $vsale );
                    $variation->set_price( $vsale );
                    $variation->save();
                    $count++;
                }
            }
        }

        return array(
            'message' => '已为产品设置折扣，共处理有价格的产品/变体：' . $count,
        );
    }

    private function tool_set_variation_prices( $price ) {
        if ( $price <= 0 ) {
            return array( 'error' => '价格必须大于 0' );
        }
        if ( ! class_exists( 'WC_Product' ) ) {
            return array( 'error' => '未检测到 WooCommerce' );
        }

        $variation_ids = wc_get_products( array(
            'type'   => array( 'variation' ),
            'status' => array( 'publish', 'pending', 'draft', 'private' ),
            'limit'  => -1,
            'return' => 'ids',
        ) );

        $count = 0;
        foreach ( $variation_ids as $vid ) {
            $variation = wc_get_product( $vid );
            if ( ! $variation ) {
                continue;
            }
            $variation->set_regular_price( $price );
            $variation->set_price( $price );
            $variation->save();
            $count++;
        }

        return array(
            'message' => '已统一设置所有变体价格，数量：' . $count,
        );
    }
 public function apply_disabled_wp_features() {
    $opts = get_option( 'wbt_disabled_features', array() );

    if ( ! empty( $opts['disable_comments'] ) ) {
        add_filter('comments_open', '__return_false', 20, 2);
        add_filter('pings_open', '__return_false', 20, 2);
        add_filter('comments_array', '__return_empty_array');
        remove_action( 'admin_menu', 'edit-comments.php' );
    }

    if ( ! empty( $opts['disable_xmlrpc'] ) ) {
        add_filter('xmlrpc_enabled', '__return_false');
    }

    if ( ! empty( $opts['disable_feed'] ) ) {
        add_action('do_feed', 'wp_die');
        add_action('do_feed_rss2', 'wp_die');
    }

    if ( ! empty( $opts['disable_emoji'] ) ) {
        remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
        remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
    }

    if ( ! empty( $opts['disable_embeds'] ) ) {
        remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
        remove_action( 'rest_api_init', 'wp_oembed_register_route' );
    }

    if ( ! empty( $opts['disable_rest_api'] ) ) {
        add_filter( 'rest_authentication_errors', function($res){
            if ( ! is_user_logged_in() )
                return new WP_Error('forbidden', 'REST API 禁用', array( 'status' => 403 ));
            return $res;
        });
    }

    if ( ! empty( $opts['disable_admin_bar'] ) ) {
        add_filter('show_admin_bar', '__return_false');
    }

    if ( ! empty( $opts['disable_auto_update'] ) ) {
        add_filter('automatic_updater_disabled', '__return_true');
    }

    if ( ! empty( $opts['disable_wp_cron'] ) ) {
        if ( ! defined('DISABLE_WP_CRON') ) {
            define( 'DISABLE_WP_CRON', true );
        }
    }

    if ( ! empty( $opts['disable_sitemap'] ) ) {
        add_filter( 'wp_sitemaps_enabled', '__return_false' );
    }

    if ( ! empty( $opts['disable_oembed_discovery'] ) ) {
        remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
    }

    if ( ! empty( $opts['disable_shortlink'] ) ) {
        remove_action('wp_head', 'wp_shortlink_wp_head');
    }

    if ( ! empty( $opts['disable_generator_meta'] ) ) {
        remove_action('wp_head', 'wp_generator');
    }
}

    public function apply_disabled_woo_features() {
        if ( ! class_exists( 'WooCommerce' ) ) {
            return;
        }

        $opts = get_option( 'wbt_disabled_woo_features', array() );
        if ( empty( $opts ) || ! is_array( $opts ) ) {
            return;
        }

        // 禁用整个 Woo Admin 后台（包括 Analytics / Marketing 等）
        if ( ! empty( $opts['disable_woo_admin'] ) ) {
            add_filter( 'woocommerce_admin_disabled', '__return_true' );
        }

        // 针对 Woo Admin 单独功能的细粒度控制
        if ( ! empty( $opts['disable_woo_analytics'] )
            || ! empty( $opts['disable_woo_marketing'] )
            || ! empty( $opts['disable_woo_remote_inbox'] )
            || ! empty( $opts['disable_woo_marketplace'] )
            || ! empty( $opts['disable_woo_marketing_tracks'] )
        ) {
            add_filter(
                'woocommerce_admin_features',
                function( $features ) use ( $opts ) {
                    if ( ! is_array( $features ) ) {
                        return $features;
                    }

                    if ( ! empty( $opts['disable_woo_analytics'] ) ) {
                        $features = array_diff( $features, array( 'analytics', 'dashboard' ) );
                    }

                    if ( ! empty( $opts['disable_woo_marketing'] ) ) {
                        $features = array_diff( $features, array( 'marketing' ) );
                    }

                    if ( ! empty( $opts['disable_woo_remote_inbox'] ) ) {
                        $features = array_diff( $features, array( 'remote-inbox-notifications' ) );
                    }

                    if ( ! empty( $opts['disable_woo_marketplace'] ) ) {
                        $features = array_diff( $features, array( 'remote-free-extensions', 'marketplace' ) );
                    }

                    if ( ! empty( $opts['disable_woo_marketing_tracks'] ) ) {
                        $features = array_diff( $features, array( 'customer-effort-score-tracks' ) );
                    }

                    return $features;
                }
            );
        }

        // 移除后台菜单项（Analytics / Marketing）
        if ( ! empty( $opts['disable_woo_analytics'] ) || ! empty( $opts['disable_woo_marketing'] ) ) {
            add_action(
                'admin_menu',
                function() use ( $opts ) {
                    if ( ! empty( $opts['disable_woo_analytics'] ) ) {
                        remove_menu_page( 'wc-admin&path=/analytics/overview' );
                    }
                    if ( ! empty( $opts['disable_woo_marketing'] ) ) {
                        remove_menu_page( 'wc-admin&path=/marketing' );
                    }
                },
                999
            );
        }
    }
   
private function save_wp_feature_settings( $data ) {
    $options = array(
        'disable_comments',
        'disable_xmlrpc',
        'disable_feed',
        'disable_emoji',
        'disable_embeds',
        'disable_rest_api',
        'disable_admin_bar',
        'disable_auto_update',
        'disable_wp_cron',
        'disable_sitemap',
        'disable_oembed_discovery',
        'disable_shortlink',
        'disable_generator_meta',
    );

    // 重置为默认（全部启用）
    if ( isset( $data['reset'] ) && intval( $data['reset'] ) === 1 ) {
        delete_option( 'wbt_disabled_features' );
        return array( 'message' => '已恢复为默认设置' );
    }

    $save = array();
    foreach ( $options as $opt ) {
        $save[ $opt ] = isset( $data[ $opt ] ) ? 1 : 0;
    }

    update_option( 'wbt_disabled_features', $save );

    return array( 'message' => '设置已保存' );
}

    private function save_woo_feature_settings( $data ) {
        $options = array(
            'disable_woo_admin',
            'disable_woo_analytics',
            'disable_woo_marketing',
            'disable_woo_remote_inbox',
            'disable_woo_marketplace',
            'disable_woo_marketing_tracks',
        );

        // 重置为默认（全部启用）
        if ( isset( $data['reset'] ) && intval( $data['reset'] ) === 1 ) {
            delete_option( 'wbt_disabled_woo_features' );
            return array( 'message' => '已恢复 Woo 默认设置' );
        }

        $save = array();
        foreach ( $options as $opt ) {
            $save[ $opt ] = isset( $data[ $opt ] ) ? 1 : 0;
        }

        update_option( 'wbt_disabled_woo_features', $save );

        return array( 'message' => 'Woo 冗余功能设置已保存' );
    }

    /* ========== Elementor 表单生成订单 ========== */

    public function handle_elementor_form( $record, $handler ) {
        if ( ! class_exists( 'WC_Order' ) ) {
            return;
        }

        $settings = get_option( self::OPTION_ELEMENTOR_ORDER, array() );
        if ( empty( $settings['form_name'] ) ) {
            return;
        }

        $form_name = $record->get_form_settings( 'form_name' );
        if ( $form_name !== $settings['form_name'] ) {
            return;
        }

        try {
            $order = wc_create_order();

            $fields = $record->get( 'fields' );
            $name   = '';
            $email  = '';

            if ( ! empty( $settings['name_field'] ) && isset( $fields[ $settings['name_field'] ] ) ) {
                $name = $fields[ $settings['name_field'] ]['value'];
            }
            if ( ! empty( $settings['email_field'] ) && isset( $fields[ $settings['email_field'] ] ) ) {
                $email = $fields[ $settings['email_field'] ]['value'];
            }

            if ( $email ) {
                $order->set_billing_email( $email );
            }
            if ( $name ) {
                $order->set_billing_first_name( $name );
            }

            $status = ! empty( $settings['order_status'] ) ? $settings['order_status'] : 'processing';
            $order->set_status( $status );
            $order->save();
        } catch ( Exception $e ) {
            // 静默失败，避免打断表单提交
        }
    }
}

endif;

WBT_Plugin::instance();